"""
HB_Selector V1.0

Last Modified: Oct/11/2018
Works with CINEMA 4D R16.050 and up.
Copyright: Holger Biebrach, www.c4dstuff.com


Name-US: HB_Selector
Description-US: Smart Selection Tool that selects Object under Cursor without changing mode (Use with Shortcut!)

Usage:
This tool offers a new way of selecting and modifying Meshes in the Viewport. While you are in Points mode for example you can quickly
select a different mesh by hovering with the mouse over the object and using the shortcut for this Script. The Object will get selected.
If you hover over a Symmetryobject or a SDS object the Script makes some smart descisions which object to select.

Video Tutorial:


ChangeLog:

Oct/11/2018 V1.0
- Release Version

"""
import c4d, sys, math
from c4d import gui
from c4d import utils

def GetNextObject(op,root):

    if op.GetType()==c4d.Opolygon or op.GetType()==c4d.Ospline or op.GetType()==c4d.Osweep or op.GetType()==c4d.Olathe or op.GetType()==1026224 or op.GetType()==1024542 or op.GetType()==c4d.Oextrude:
        op.SetBit(c4d.BIT_ACTIVE)
        doc.SetMode(c4d.Mpoints)
    else:
        doc.SetMode(c4d.Mmodel)
        
    if op.GetType()==c4d.Ospline or op.GetType()==c4d.Osweep or op.GetType()==c4d.Olathe or op.GetType()==c4d.Oextrude:
        drawBD = doc.GetActiveBaseDraw()
        drawBD[c4d.BASEDRAW_DATA_XRAY]=True
        drawBD[c4d.BASEDRAW_DISPLAYFILTER_SPLINE]=True

    if op==None:
        return None

    if op.GetDown():
        return op.GetDown()

    while not op.GetNext() and op!=root and op.GetUp()!=root and op.GetUp():
        op = op.GetUp()

    if op !=root:
        return op.GetNext()


def IterateChildren(objlist):

    for obj in objlist:
    
        if obj.GetType()!=c4d.Opolygon or obj.GetType()!=c4d.Ospline or obj.GetType()!=c4d.Osweep or obj.GetType()!=c4d.Olathe or obj.GetType()!=c4d.Osymmetry or op.GetType()==1024542:
            obj.DelBit(c4d.BIT_ACTIVE)
            

                
        
      

        root = obj
        while obj:
            obj = GetNextObject(obj,root)


    if obj is None:
        return

    return

def Deselect(objlist):

    for obj in objlist:
        obj.DelBit(c4d.BIT_ACTIVE)

    return


def SelectIfPolygonal(obj):
    if obj.GetType()==c4d.Opolygon or obj.GetType()==c4d.Ospline:
        obj.SetBit(c4d.BIT_ACTIVE)

    return


def IsChildOf (obj,Parentobj):
    while obj:
        if obj==Parentobj: return True
        obj = obj.GetUp()

def GetFirstActiveObject(objlist):
    for obj in objlist:
        if obj.GetBit(c4d.BIT_ACTIVE): return obj



def PickObj():

    bd = doc.GetActiveBaseDraw()
    bc = c4d.BaseContainer()

    gui.GetInputState(c4d.BFM_INPUT_MOUSE, c4d.BFM_INPUT_MOUSELEFT, bc)
    mouse_x=bc.GetInt32(c4d.BFM_INPUT_X)
    mouse_y=bc.GetInt32(c4d.BFM_INPUT_Y)

    # Convert MouseCoordinates to Viewport Coordinates
    win= bd.GetEditorWindow()
    Editor_x, Editor_y = win.Global2Local()
    mouse_x = mouse_x-abs(Editor_x)
    mouse_y = mouse_y-abs(Editor_y)
    #print mouse_x

    ViewportSelect = c4d.utils.ViewportSelect()
    pick_objects = ViewportSelect.PickObject(bd, doc, mouse_x, mouse_y, rad=0, flags=c4d.VIEWPORT_PICK_FLAGS_0)
    #print "PickObj: ", pick_objects[0].GetName()

    frame = bd.GetFrame()
    left = frame["cl"]
    right = frame["cr"]
    top = frame["ct"]
    bottom = frame["cb"]
    width = right - left + 1
    height = bottom - top +1

    if len(pick_objects)==0: return False

    for obj in pick_objects:
        obj_info = obj.GetInfo()
        is_deformer = obj_info & c4d.OBJECT_MODIFIER
        if not is_deformer:
            return obj


###################################  MAIN    ###########################

def main():


    SelectedObjs = doc.GetSelection()

    c4dVersion= c4d.GetC4DVersion()
    FirstPick = PickObj()

    if not FirstPick:
        return

    obj_info = FirstPick.GetInfo()
    is_generator = obj_info & c4d.OBJECT_GENERATOR


    if is_generator:
    
       
        # Object is SDS or Symmetry or Charcter
        if FirstPick.GetType() == c4d.Osds or FirstPick.GetType()==c4d.Osymmetry or FirstPick.GetType()==c4d.Ocharacter:
            
            ################### SECOND PICK   ###################
            FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=False
            SecondPick = PickObj()
            
            ##### Only One Symobj
            Flipped=False

            if not SecondPick or not IsChildOf (SecondPick,FirstPick) :
                c4d.CallButton(FirstPick(), c4d.SYMMETRYOBJECT_FLIP)
                SecondPick = PickObj()
                Flipped=True



            if  SecondPick.GetType()!=c4d.Osymmetry and SecondPick.GetType()!=c4d.Osds and SecondPick.GetType()!=100004007:


                if FirstPick.GetType()==c4d.Osymmetry: # If Symmetry FLIP Symmetry

                    if c4dVersion < 17000:# R16 and lower dont have Flip option
                        FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                        return



                    FinalPick = PickObj()
                    FinalPick.SetBit(c4d.BIT_ACTIVE)
                    FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                    Deselect(SelectedObjs)
                    if doc.GetMode()==c4d.Mmodel: doc.SetMode(c4d.Mpoints)
                    return

            else:
                SecondPick.SetBit(c4d.BIT_ACTIVE)


            #######   SYM UNDER SDS  ############

            if SecondPick.GetType()==c4d.Osymmetry:
                SecondPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=False
                ThirdPick= PickObj()

                if not IsChildOf(ThirdPick,SecondPick) or not ThirdPick:
                    if c4dVersion < 17000:# R16 and lower dont have Flip option
                        FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                        return
                    c4d.CallButton(SecondPick(), c4d.SYMMETRYOBJECT_FLIP)

                    FinalPick = PickObj()
                    FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                    SecondPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                    FinalPick.SetBit(c4d.BIT_ACTIVE)
                    SecondPick.DelBit(c4d.BIT_ACTIVE)

                else:
                    ThirdPick.SetBit(c4d.BIT_ACTIVE)
                    FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                    SecondPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                    SecondPick.DelBit(c4d.BIT_ACTIVE)


            #######  SDS UNDER SYM  ############

            if SecondPick.GetType()==c4d.Osds or SecondPick.GetType()==100004007:
                
                SecondPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=False
                ThirdPick= PickObj()

                if IsChildOf(ThirdPick,SecondPick) or not ThirdPick:

                    if c4dVersion < 17000:# R16 and lower dont have Flip option
                        FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                        return
                    c4d.CallButton(SecondPick(), c4d.SYMMETRYOBJECT_FLIP)

                    FinalPick = PickObj()

                    FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                    SecondPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                    FinalPick.SetBit(c4d.BIT_ACTIVE)
                    SecondPick.DelBit(c4d.BIT_ACTIVE)
                    Deselect(SelectedObjs)
                    if doc.GetMode()==c4d.Mmodel: doc.SetMode(c4d.Mpoints)
                    return

                else:
                    
                    ThirdPick.SetBit(c4d.BIT_ACTIVE)
                    SecondPick.DelBit(c4d.BIT_ACTIVE)
                    FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
                    SecondPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True

            
            FirstPick[c4d.ID_BASEOBJECT_GENERATOR_FLAG]=True
            Deselect(SelectedObjs)

            SecondPick.SetBit(c4d.BIT_ACTIVE)
            if SecondPick.GetType()==c4d.Osymmetry or SecondPick.GetType()==c4d.Osds:
                SecondPick.DelBit(c4d.BIT_ACTIVE)
           
            if doc.GetMode()==c4d.Mmodel: doc.SetMode(c4d.Mpoints)
            return
        
            
        
        else:
            print "yes"
            
            
            IterateChildren([FirstPick])
            
            FirstPick.SetBit(c4d.BIT_ACTIVE)
            Deselect(SelectedObjs)
            c4d.EventAdd()
            return
    


   
    
    if doc.GetMode()==c4d.Mmodel: doc.SetMode(c4d.Mpoints)
    SelectIfPolygonal(FirstPick)
    Deselect(SelectedObjs)



if __name__=='__main__':
    main()
    c4d.EventAdd()